/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.IntegerContentCommand;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.datatool.DataTemporalElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolBaseSty;
import com.dickimawbooks.texparserlib.latex.datatool.DatumType;
import com.dickimawbooks.texparserlib.latex.datatool.Julian;
import java.io.IOException;
import java.util.Date;

public class DataDateElement
extends AbstractTeXObject
implements DataTemporalElement,
Expandable {
    protected Julian julian;
    protected TeXObject original;

    public DataDateElement() {
        this(0);
    }

    public DataDateElement(Number number) {
        this(number.intValue(), null);
    }

    public DataDateElement(TeXNumber teXNumber) {
        this(teXNumber.getValue(), null);
    }

    public DataDateElement(int n) {
        this(n, null);
    }

    public DataDateElement(int n, TeXObject teXObject) {
        this(Julian.createDay(n), teXObject);
    }

    public DataDateElement(Julian julian) {
        this(julian, null);
    }

    public DataDateElement(Julian julian, TeXObject teXObject) {
        this.julian = julian;
        this.original = teXObject;
    }

    @Override
    public Object clone() {
        return new DataDateElement(this.julian, this.original == null ? null : (TeXObject)this.original.clone());
    }

    @Override
    public double doubleValue() {
        return this.intValue();
    }

    @Override
    public float floatValue() {
        return this.intValue();
    }

    @Override
    public int intValue() {
        return this.julian.getJulianDay();
    }

    @Override
    public long longValue() {
        return this.intValue();
    }

    @Override
    public Date getDate() {
        return new Date(this.julian.toUnixEpochMillis());
    }

    @Override
    public Julian getJulian() {
        return this.julian;
    }

    @Override
    public TeXObject getTeXValue(TeXParser teXParser) {
        TeXParserListener teXParserListener = teXParser.getListener();
        TeXObjectList teXObjectList = teXParserListener.createStack();
        teXObjectList.add(new TeXCsRef("DTLtemporalvalue"));
        Group group = teXParserListener.createGroup();
        teXObjectList.add(group);
        group.add(new UserNumber(this.intValue()));
        if (this.original == null) {
            teXObjectList.add(teXParserListener.createGroup(this.julian.getTimeStamp()));
        } else {
            group = teXParserListener.createGroup();
            group.add((TeXObject)this.original.clone(), true);
            teXObjectList.add(group);
        }
        return teXObjectList;
    }

    @Override
    public TeXObject getContent(TeXParser teXParser) {
        if (this.original == null) {
            return teXParser.getListener().createString(DataToolBaseSty.DATE_FORMAT.format(this.getDate()));
        }
        return this.original;
    }

    @Override
    public TeXObject getCurrencySymbol() {
        return null;
    }

    @Override
    public void advance(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        int n = this.intValue();
        this.julian = Julian.createDay(n += numerical.number(teXParser));
        this.original = null;
    }

    @Override
    public void divide(int n) {
        int n2 = this.intValue();
        this.julian = Julian.createDay(n2 /= n);
        this.original = null;
    }

    @Override
    public void multiply(int n) {
        int n2 = this.intValue();
        this.julian = Julian.createDay(n2 *= n);
        this.original = null;
    }

    @Override
    public int number(TeXParser teXParser) throws TeXSyntaxException {
        return this.intValue();
    }

    @Override
    public byte getDataType() {
        return 5;
    }

    @Override
    public DatumType getDatumType() {
        return DatumType.DATE;
    }

    @Override
    public boolean canExpand() {
        return true;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser, teXParser);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (teXParser.isStack(this.original)) {
            return (TeXObjectList)this.original.clone();
        }
        TeXParserListener teXParserListener = teXParser.getListener();
        TeXObjectList teXObjectList2 = teXParserListener.createStack();
        if (this.original == null) {
            teXObjectList2.add(teXParserListener.getControlSequence("__texparser_fmt_date_value:n"));
            teXObjectList2.add(new UserNumber(this.intValue()));
        } else {
            teXObjectList2.add((TeXObject)this.original.clone());
        }
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandfully(teXParser, teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return teXParser.getListener().createString(this.format());
    }

    @Override
    public String format() {
        if (this.original == null) {
            return DataToolBaseSty.DATE_FORMAT.format(this.getDate());
        }
        return this.original.format();
    }

    @Override
    public String toString(TeXParser teXParser) {
        if (this.original == null) {
            return DataToolBaseSty.DATE_FORMAT.format(this.getDate());
        }
        return this.original.toString(teXParser);
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return teXParser.string(this.toString(teXParser));
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXParserListener teXParserListener = teXParser.getListener();
        if (this.original == null) {
            TeXObjectList teXObjectList2 = teXParserListener.createStack();
            teXObjectList2.add(teXParserListener.getControlSequence("__texparser_fmt_date_value:n"));
            teXObjectList2.add(new UserNumber(this.intValue()));
            TeXParserUtils.process(teXObjectList2, teXParser, teXObjectList);
        } else {
            TeXParserUtils.process(this.original, teXParser, teXObjectList);
        }
    }

    public String toString() {
        return String.format("%s[julian=%s,original=%s]", this.getClass().getSimpleName(), this.julian, this.original);
    }

    @Override
    public ControlSequence createControlSequence(String string) {
        return new IntegerContentCommand(string, this.intValue());
    }
}

