# xsipa – XSAMPA to IPA Transcription in LaTeX

`xsipa` is a LaTeX package that provides a lightweight phonetic transcription system inspired by XSAMPA. It translates modified XSAMPA sequences into proper IPA symbols, using either the `tipa` package (for pdfTeX users) or Unicode IPA symbols via `xunicode` (for XeTeX and LuaTeX users).

This package was designed to simplify phonetic transcription in LaTeX by offering concise macros such as `\xsE` for `\textepsilon`, and `\xs*...*` as a shortcut for multi-symbol sequences (e.g., `\xs*EO*` for `ɛɔ`). These commands are modeled after XSAMPA but adapted for LaTeX compatibility — including custom replacements for reserved characters.

## Key Features

- XSAMPA-inspired syntax adapted for LaTeX usage
- Short and readable macro names
- Transparent support for `tipa` or Unicode output based on the engine:
  - XeTeX / LuaTeX → Unicode (via `xunicode`)
  - pdfTeX → `tipa`
- Minimal setup; no need to load fonts manually
- Built-in compatibility workarounds for LaTeX special characters

## Requirements

- A working LaTeX distribution with one of the following engines:
  - XeTeX
  - LuaTeX
  - pdfTeX
- The following packages must be available in your system:
  - `xparse`
  - `xunicode` (for Unicode-based output)
  - `tipa` (for pdfTeX-based output)
  - `iftex` (used for engine detection)

These packages are included in most standard TeX distributions such as TeX Live or MiKTeX.

## License

This material is subject to the **LaTeX Project Public License 1.3c or any later version**. You may obtain a copy of the license at:

> http://www.latex-project.org/lppl.txt

This software is provided "as is", and there is no warranty for correctness or fitness for a particular purpose.

## Author

**Akpoué Kouamé Josué**  
Email: djosuebetsaleelakpoue@gmail.com

## Repository

GitHub: [https://github.com/dbjoshua/xsipa_package](https://github.com/dbjoshua/xsipa_package)

